<?php include 'db.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Discover Sri Lanka – Wonder Lanka</title>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css"/>
  <style>
    *{margin:0;padding:0;box-sizing:border-box;}
    body{font-family:"Poppins",sans-serif;background:#f8fafc;color:#333;line-height:1.6;}
    
    /* Header */
    header{
      background:#fff;
      display:flex;justify-content:space-between;align-items:center;
      padding:20px 8%;box-shadow:0 2px 8px rgba(0,0,0,0.05);
      position:sticky;top:0;z-index:10;
    }
    header h1{color:#00897b;font-weight:700;}
    nav a{
      text-decoration:none;color:#333;margin:0 15px;font-weight:500;position:relative;
    }
    nav a:hover{color:#00897b;}
    nav a::after{
      content:"";position:absolute;left:0;bottom:-5px;width:0;height:2px;background:#00897b;transition:width 0.3s;
    }
    nav a:hover::after{width:100%;}

    /* Hero */
    .hero{
      background: linear-gradient(rgba(0,0,0,0.35), rgba(0,0,0,0.35)), url('images/WhatsApp Image 2025-10-14 at 12.20.13.jpeg') center/cover no-repeat;
      color:#fff;text-align:center;padding:160px 8%;position:relative;
      display:flex;align-items:center;justify-content:center;flex-direction:column;
      animation: fadeInHero 1.5s ease;
    }
    .hero-content h1{font-size:3em;letter-spacing:2px;margin-bottom:10px;animation: slideDown 1s ease;}
    .hero-content p{font-size:1.2em;color:#e0f2f1;animation: slideUp 1s ease;}
    
    /* Container */
    .container{max-width:1200px;margin:60px auto;padding:0 8%;}

    /* Section Titles */
    .section-title{text-align:center;font-size:2em;color:#00796b;margin-bottom:40px;position:relative;}
    .section-title::after{
      content:"";width:60px;height:3px;background:#00897b;display:block;margin:10px auto;border-radius:2px;
    }

    /* Climate Section */
    .climate{
      background:#e0f2f1;padding:60px 20px;text-align:center;border-radius:15px;margin-top:40px;
      display:flex;justify-content:center;flex-wrap:wrap;gap:30px;
    }
    .climate-card{
      background:#fff;padding:25px;border-radius:15px;box-shadow:0 6px 18px rgba(0,0,0,0.1);
      flex:1 1 250px;transition:transform .3s, box-shadow .3s;
    }
    .climate-card:hover{transform:translateY(-5px);box-shadow:0 12px 25px rgba(0,0,0,0.15);}
    .climate-icon{font-size:3em;margin-bottom:15px;color:#00796b;}
    .climate-card h3{color:#004d40;margin-bottom:15px;}
    .climate-card p{font-size:1.1em;color:#333;margin-bottom:8px;}

    /* Events Section */
    .events{margin-top:60px;}
    .event-grid{display:grid;grid-template-columns:repeat(auto-fit,minmax(300px,1fr));gap:25px;}
    .event-card{
      background:#fff;padding:25px;border-radius:15px;box-shadow:0 5px 15px rgba(0,0,0,0.1);
      transition:transform .3s, box-shadow .3s;
    }
    .event-card:hover{transform:translateY(-6px);box-shadow:0 10px 25px rgba(0,0,0,0.15);}
    .event-card h3{color:#00796b;margin-bottom:10px;}
    .event-card span{display:block;color:#999;margin-bottom:10px;font-size:.9em;}
    .event-card p{color:#555;}

    /* Gallery */
    .gallery{margin-top:60px;}
    .gallery-grid{display:grid;grid-template-columns:repeat(auto-fit,minmax(250px,1fr));gap:15px;}
    .gallery-grid img{
      width:100%;height:220px;object-fit:cover;border-radius:12px;
      transition:transform .3s ease, filter .3s;
      cursor:pointer;
    }
    .gallery-grid img:hover{transform:scale(1.05);filter:brightness(1.1);}
    
    /* Lightbox */
    #lightbox{
      position:fixed;top:0;left:0;width:100%;height:100%;background:rgba(0,0,0,0.85);
      display:flex;align-items:center;justify-content:center;opacity:0;visibility:hidden;transition:0.3s;
    }
    #lightbox img{max-width:90%;max-height:90%;border-radius:12px;}
    #lightbox.show{opacity:1;visibility:visible;}

    /* Footer */
    footer{text-align:center;padding:40px 8%;background:#004d40;color:#e0f2f1;margin-top:80px;}
    footer a{color:#80cbc4;text-decoration:none;margin:0 10px;}
    footer a:hover{color:#fff;}

    /* Animations */
    @keyframes fadeInHero{from{opacity:0}to{opacity:1}}
    @keyframes slideDown{from{opacity:0;transform:translateY(-50px)}to{opacity:1;transform:translateY(0)}}
    @keyframes slideUp{from{opacity:0;transform:translateY(50px)}to{opacity:1;transform:translateY(0)}}

    /* Responsive */
    @media (max-width:768px){.climate{flex-direction:column;}}
  </style>
</head>
<body>

<header>
  <h1>Wonder Lanka</h1>
  <nav>
    <a href="index.php">Home</a>
    <a href="discover.php">Discover</a>
    <a href="blog.php">Blog</a>
    <a href="about.php">About</a>
    <a href="contact.php">Contact</a>
  </nav>
</header>

<section class="hero">
  <div class="hero-content">
    <h1>Discover Sri Lanka</h1>
    <p>Explore culture, climate, and the island’s unique heartbeat.</p>
  </div>
</section>

<!-- Climate Section -->
<div class="container climate">
  <div class="climate-card">
    <div class="climate-icon"><i class="fas fa-sun"></i></div>
    <h3>Temperature</h3>
    <p>☀️ <span id="temp">Loading...</span></p>
  </div>
  <div class="climate-card">
    <div class="climate-icon"><i class="fas fa-cloud-sun-rain"></i></div>
    <h3>Condition</h3>
    <p>🌧 <span id="condition">Loading...</span></p>
  </div>
  <div class="climate-card">
    <div class="climate-icon"><i class="fas fa-wind"></i></div>
    <h3>Wind</h3>
    <p>💨 <span id="wind">Loading...</span></p>
  </div>
</div>

<!-- Events Section -->
<div class="container events">
  <h2 class="section-title">Upcoming Events</h2>
  <div class="event-grid">
    <div class="event-card">
      <h3>Kandy Esala Perahera</h3>
      <span>August 2025</span>
      <p>Witness Sri Lanka’s most sacred and colorful cultural procession — a festival of lights, dancers, and elephants.</p>
    </div>
    <div class="event-card">
      <h3>Galle Literary Festival</h3>
      <span>January 2026</span>
      <p>Celebrate literature and creativity at the scenic Galle Fort, featuring global authors and storytellers.</p>
    </div>
    <div class="event-card">
      <h3>Colombo Food Festival</h3>
      <span>June 2026</span>
      <p>Taste authentic Sri Lankan dishes and fusion cuisine from top chefs and food stalls across the island.</p>
    </div>
  </div>
</div>

<!-- Gallery Section -->
<div class="container gallery">
  <h2 class="section-title">Gallery of Sri Lanka</h2>
  <div class="gallery-grid">
    <img src="images/WhatsApp Image 2025-10-15 at 21.17.06.jpeg" alt="Sigiriya Rock Fortress">
    <img src="images/WhatsApp Image 2025-10-15 at 21.17.44.jpeg" alt="Galle Fort Sunset">
    <img src="images/WhatsApp Image 2025-10-15 at 21.18.06.jpeg" alt="Ella Train Ride">
    <img src="images/WhatsApp Image 2025-10-14 at 12.30.46.jpeg" alt="Temple of the Tooth">
    <img src="images/WhatsApp Image 2025-10-15 at 21.18.26.jpeg" alt="Beach at Mirissa">
    <img src="images/WhatsApp Image 2025-10-15 at 21.18.45.jpeg" alt="Horton Plains">
  </div>
</div>

<div id="lightbox"><img src="" alt=""></div>

<footer>
  <p>
    <a href="index.php">Home</a>
    <a href="discover.php">Discover</a>
    <a href="blog.php">Blog</a>
    <a href="about.php">About</a>
    <a href="contact.php">Contact</a>
  </p>
  <p>© 2025 Wonder Lanka. All Rights Reserved.</p>
</footer>

<script>
// Weather API
fetch('https://api.open-meteo.com/v1/forecast?latitude=7.8731&longitude=80.7718&current_weather=true')
  .then(response => response.json())
  .then(data => {
    const w = data.current_weather;
    document.getElementById("temp").textContent = w.temperature + "°C";
    document.getElementById("condition").textContent = w.weathercode < 3 ? "Clear Skies" : "Cloudy";
    document.getElementById("wind").textContent = w.windspeed + " km/h";
  })
  .catch(() => {
    document.getElementById("temp").textContent = "Unavailable";
    document.getElementById("condition").textContent = "Unavailable";
    document.getElementById("wind").textContent = "Unavailable";
  });

// Gallery Lightbox
const lightbox = document.getElementById('lightbox');
const lightboxImg = lightbox.querySelector('img');
document.querySelectorAll('.gallery-grid img').forEach(img => {
  img.addEventListener('click', () => {
    lightboxImg.src = img.src;
    lightbox.classList.add('show');
  });
});
lightbox.addEventListener('click', ()=>lightbox.classList.remove('show'));
</script>

</body>
</html>
